/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public abstract class CompatModule {
    protected final String modId;

    protected CompatModule(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public abstract String shortenedId();

    public String toString() {
        return "EveryCompat " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public class_2960 modRes(String string) {
        return new class_2960(this.modId, string);
    }

    public List<String> getAlreadySupportedMods() {
        return List.of();
    }

    public void onModSetup() {
    }

    public void onClientInit() {
    }

    public void onClientSetup() {
    }

    public void registerWoodBlocks(Registrator<class_2248> registry, Collection<WoodType> woodTypes) {
    }

    public void registerLeavesBlocks(Registrator<class_2248> registry, Collection<LeavesType> leavesTypes) {
    }

    public void registerItems(Registrator<class_1792> registry) {
    }

    public void registerTiles(Registrator<class_2591<?>> registry) {
    }

    public void registerEntities(Registrator<class_1299<?>> registry) {
    }

    public final boolean isEntryAlreadyRegistered(String name, BlockType woodType, class_2378<?> registry) {
        name = name.substring(name.lastIndexOf("/") + 1);
        String woodFrom = woodType.getNamespace();
        if (this.getAlreadySupportedMods().contains(woodFrom)) {
            return true;
        }
        if (woodFrom.equals(this.modId)) {
            return true;
        }
        String n1 = woodFrom + "/" + name;
        String n2 = woodFrom + "_" + name;
        if (woodType.getId().toString().equals("ecologics:azalea") && this.modId.equals("quark")) {
            return false;
        }
        if (woodType.getId().toString().equals("twilightforest:mangrove")) {
            return name.equals("mangrove_chest");
        }
        if (registry.method_10250(new class_2960(this.modId, name)) || registry.method_10250(new class_2960(this.modId, n2))) {
            return true;
        }
        if (this.shortenedId().equals("af")) {
            return false;
        }
        if (this.shortenedId().equals("vs")) {
            return false;
        }
        if (registry.method_10250(new class_2960(woodFrom, name))) {
            return true;
        }
        for (EveryCompat.CompatMod c : EveryCompat.COMPAT_MODS) {
            String compatModId = c.modId();
            if (!woodFrom.equals(c.woodFrom()) || !c.blocksFrom().contains(this.modId)) continue;
            if (registry.method_10250(new class_2960(compatModId, name))) {
                return true;
            }
            if (registry.method_10250(new class_2960(compatModId, n1))) {
                return true;
            }
            if (!registry.method_10250(new class_2960(compatModId, n2))) continue;
            return true;
        }
        return false;
    }

    public void addStaticServerResources(ServerDynamicResourcesHandler handler, class_3300 manager) {
    }

    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, class_3300 manager) {
    }

    public void addStaticClientResources(ClientDynamicResourcesHandler handler, class_3300 manager) {
    }

    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, class_3300 manager) {
    }

    public void registerBlockEntityRenderers(ClientPlatformHelper.BlockEntityRendererEvent event) {
    }

    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
    }

    public void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
    }

    public void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
    }

    protected final <T extends class_2248> T getModBlock(String id, Class<T> blockClass) {
        return (T)((class_2248)class_2378.field_11146.method_10223(this.modRes(id)));
    }

    protected final class_2248 getModBlock(String id) {
        return (class_2248)class_2378.field_11146.method_10223(this.modRes(id));
    }

    public void addWoodTexture(WoodType wood, DynClientResourcesProvider handler, class_3300 manager, String path, Supplier<TextureImage> textureSupplier) {
        handler.addTextureIfNotPresent(manager, path, () -> {
            TextureImage t = (TextureImage)textureSupplier.get();
            this.maybeFlowerAzalea(t, manager, wood);
            return t;
        });
    }

    protected void maybeFlowerAzalea(TextureImage image, class_3300 manager, WoodType woodType) {
        WoodType azalea;
        if (woodType.getId().toString().equals("ecologics:flowering_azalea") && (azalea = WoodTypeRegistry.getValue((class_2960)new class_2960("ecologics:azalea"))) != null) {
            try (TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)azalea.planks));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, mask});
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("failed to apply azalea overlay: ", (Throwable)e);
            }
        }
    }

    public <T extends BlockType, B extends class_2248> Function<T, @Nullable B> ifHasChild(Function<T, B> supplier, String ... children) {
        return w -> {
            for (String v : children) {
                if (w.getChild(v) != null) continue;
                return null;
            }
            return (class_2248)supplier.apply(w);
        };
    }

    public void onFirstClientTick() {
    }
}

